<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fmp="http://www.filemaker.com/fmpxmlresult" exclude-result-prefixes="fmp">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
<!--
File: simple_table.xsl

Transforms data exported in the FMPXMLRESULT grammar into an 
HTML table. 

===============================================================

Copyright © 2002 FileMaker, Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following
conditions are met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in 
  the documentation and/or other materials provided with the
  distribution.

* Neither the name of the FileMaker, Inc. nor the names of its 
  contributors may be used to endorse or promote products derived
  from this software without specific prior written
  permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
    
===============================================================
-->
<!--
Template: match="fmp:FMPXMLRESULT"

The main driver for building the table. Calls the header template then iterates through
 the RESULTSET nodeset to build the table rows.
-->
	<xsl:template match="fmp:FMPXMLRESULT">
		<html>
			<body>
				<table border="1" cellPadding="1" cellSpacing="1">
					<xsl:call-template name="header"/>
					<xsl:for-each select="fmp:RESULTSET/fmp:ROW">
						<tr>
							<xsl:for-each select="fmp:COL">
								<td>
									<xsl:value-of select="fmp:DATA"/>
								</td>
							</xsl:for-each>
						</tr>
					</xsl:for-each>
				</table>
			</body>
		</html>
	</xsl:template>
<!--
Template: header

Creates the heading for the HTML table. The database name and number of records
are displayed above the field names.
-->
	<xsl:template name="header">
		<tr>
			<td align="middle">
				<xsl:attribute name="colspan"><xsl:call-template name="numfields"/></xsl:attribute>
				<xsl:text>Database: </xsl:text>
				<xsl:value-of select="fmp:DATABASE/@NAME"/>
			</td>
		</tr>
		<tr>
			<td align="middle">
				<xsl:attribute name="colspan"><xsl:call-template name="numfields"/></xsl:attribute>
				<xsl:text>Records: </xsl:text>
				<xsl:value-of select="fmp:DATABASE/@RECORDS"/>
			</td>
		</tr>
		<tr>
			<xsl:for-each select="fmp:METADATA/fmp:FIELD">
				<td align="middle">
					<xsl:value-of select="@NAME"/>
				</td>
			</xsl:for-each>
		</tr>
	</xsl:template>
<!--
Template: numfields

Simple utility template that checks for the number of children in the METADATA
element and returns the number of fields in the database - handy when building
tables.
-->
	<xsl:template name="numfields" match="fmp:METADATA">
		<xsl:value-of select="count(fmp:METADATA/child::*)"/>
	</xsl:template>
</xsl:stylesheet>
